<?php
/* --------------------------------------------------------------
   UserConfiguration.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Interfaces;

/**
 * Interface UserConfiguration
 *
 * @package Gambio\Admin\UserConfiguration\Interfaces
 */
interface UserConfiguration
{
    /**
     * Returns the configuration key
     *
     * @return string
     */
    public function key(): string;
    
    
    /**
     * Returns the configuration value
     *
     * @return string
     */
    public function value(): string;
}